// By EVOLVED
// www.evolved-software.com

#define MotionBlur 1

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 View:View;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection; 
   float4x4 Project:Projection; 
   float4x4 PrevViewProj;

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float2 CamRange;
   float Offset=4;
   float MotionVec=0.025;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Proj:TEXCOORD0;
	float4 CurrPos:TEXCOORD1;
	float4 PrevPos:TEXCOORD2;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(IN.Pos,WorldVP);
	float3 WorldPos=mul(IN.Pos,World); 
	Project[2].z=-1.0/(CamRange.y-CamRange.x), Project[3].z=(CamRange.y-CamRange.x)/CamRange.y;
	float4 PosLinear=mul(mul(float4(WorldPos,1),View),Project); 
        OUT.Proj=float4(PosLinear.x*0.5+0.5*PosLinear.w,0.5*PosLinear.w-PosLinear.y*0.5,PosLinear.z,PosLinear.w);
	OUT.CurrPos=OUT.Pos;
	OUT.PrevPos=mul(mul(IN.Pos,World),PrevViewProj); 
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float4 Tex=(IN.Proj/IN.Proj.w)+ViewSize.xyyy;
	float3 FrameRender=tex2Dlod(RenderSampler,Tex).xyz*0.25
	                  +tex2Dlod(RenderSampler,Tex+float4(ViewSize.x,ViewSize.y,0,0)*Offset).xyz*0.0625
			  +tex2Dlod(RenderSampler,Tex+float4(0,ViewSize.y,0,0)*Offset).xyz*0.125
		          +tex2Dlod(RenderSampler,Tex+float4(-ViewSize.x,ViewSize.y,0,0)*Offset).xyz*0.0625
			  +tex2Dlod(RenderSampler,Tex+float4(ViewSize.x,0,0,0)*Offset).xyz*0.125
			  +tex2Dlod(RenderSampler,Tex+float4(-ViewSize.x,0,0,0)*Offset).xyz*0.125
		          +tex2Dlod(RenderSampler,Tex+float4(ViewSize.x,-ViewSize.y,0,0)*Offset).xyz*0.0625
			  +tex2Dlod(RenderSampler,Tex+float4(0,-ViewSize.y,0,0)*Offset).xyz*0.125
			  +tex2Dlod(RenderSampler,Tex+float4(-ViewSize.x,-ViewSize.y,0,0)*Offset).xyz*0.0625;
	float Mask=0.0;
	#if MotionBlur ==1
	 float2 PixelVelocity=(IN.CurrPos.xy/IN.CurrPos.w)-(IN.PrevPos.xy/IN.PrevPos.w);
    	 PixelVelocity=clamp(float2(-PixelVelocity.x*0.5,PixelVelocity.y*0.5),-1.0,1.0);
	 Mask=abs(PixelVelocity.x)+abs(PixelVelocity.y);
    	 PixelVelocity *=MotionVec;
	 float3 MotionBlurRender=0.0;
	 for (int i=-8; i < 9; i++) MotionBlurRender +=tex2Dlod(RenderSampler,Tex+PixelVelocity.xyyy*i).xyz;
	 FrameRender=lerp(FrameRender,MotionBlurRender/17,saturate(Mask*255));
	#endif
	return float4(FrameRender,saturate(Mask*64));
     }

//--------------
// techniques   
//--------------
    technique Downfilter
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
	CullMode=cw;
      }
      }
